/** @file   carnivoreai.h
 * @brief   Declaration of CarnivoreAI class.
 * @version $Revision: 1.3 $
 * @date    $Date: 2006/02/26 07:39:22 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_CARNIVOREAI_H
#define H_WWW_CARNIVOREAI_H

#include "aicontroller.h"
#include "vec2d.h"

namespace WeWantWar {


/** @class  CarnivoreAI
 * @brief   The main logic that moves and controls the CarnivoreAlien
 * @author  Tomi Lamminsaari
 *
 * @par Behaviour of Carnivore Alien
 * The Carnivore Alien moves randomly around the level as long as he gets
 * the player in sight. When he's able to see player, he tries to attack him.
 * As he gets close enough, he takes a short sprint towards the player.
 * @par
 * The Carnivore Alien has also a memory. As they first time see the player and
 * althoug the player then hides himself, the alien remembers where he saw
 * the player last time and keeps on heading there.
 */
class CarnivoreAI : public AIController
{
public:

  ///
  /// Static members
  /// ==============
  
  

  ///
  /// Constructor, destructor
  /// =======================
  
  /** Constructor.
   * @param     pAlien            Pointer to GameObject we're controlling.
   */
  CarnivoreAI( GameObject* pAlien );
  
  /** Constructs new AI object and sets the target.
   * @param     pAlien            Pointer to GameObject we're controlling.
   * @param     pTarget           Pointer to target GameObject.
   */
  CarnivoreAI( GameObject* pAlien, GameObject* pTarget );
  
  /** Destructor
   */
  virtual ~CarnivoreAI();
  
  
  ///
  /// Methods
  /// =======
  
  /** Implements the controlling of the Carnivore Alien.
   * @param     seeTarget         This implies if we can see our target.
   * @param     dist              Direct distance from our target.
   */
  virtual void updateAI( bool seeTarget, float dist );
  
  
protected:

  ///
  /// Members
  /// =======
  
  /** Are we in alerted mode. This means that we should look for player. */
  bool  m_alerted;
  
  /** The sprint distance */
  float m_sprintDistance;

  /** The position where we last time saw the player. */
  eng2d::Vec2D  m_lastKnownPos;
  

private:
  /** Disabled copycontructor. */
  CarnivoreAI( const CarnivoreAI& rO );
  /** Disabled assignment operator */
  CarnivoreAI& operator = ( const CarnivoreAI& rO );
};

};  // end of namespace

#endif // CARNIVOREAI_H

/**
 * Version history
 * ===============
 * $Log: carnivoreai.h,v $
 * Revision 1.3  2006/02/26 07:39:22  lamminsa
 * no message
 *
 * Revision 1.2  2006/02/24 12:23:03  lamminsa
 * eng2d::MMapDataProvider interface implementation.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:50+02  lamminsa
 * Initial revision
 *
 */
